// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     mojo/services/network/public/interfaces/tcp_bound_socket.mojom
//

package org.chromium.mojom.mojo;

class TcpBoundSocket_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<TcpBoundSocket, TcpBoundSocket.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<TcpBoundSocket, TcpBoundSocket.Proxy>() {
    
        public String getName() {
            return "mojo::TCPBoundSocket";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, TcpBoundSocket impl) {
            return new Stub(core, impl);
        }
    
        public TcpBoundSocket[] buildArray(int size) {
          return new TcpBoundSocket[size];
        }
    };

    private static final int START_LISTENING_ORDINAL = 0;
    private static final int CONNECT_ORDINAL = 1;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements TcpBoundSocket.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void startListening(org.chromium.mojo.bindings.InterfaceRequest<TcpServerSocket> server, StartListeningResponse callback) {
            TcpBoundSocketStartListeningParams _message = new TcpBoundSocketStartListeningParams();
            _message.server = server;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    START_LISTENING_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new TcpBoundSocketStartListeningResponseParamsForwardToCallback(callback));
        }

        @Override
        public void connect(NetAddress remoteAddress, org.chromium.mojo.system.DataPipe.ConsumerHandle sendStream, org.chromium.mojo.system.DataPipe.ProducerHandle receiveStream, org.chromium.mojo.bindings.InterfaceRequest<TcpConnectedSocket> clientSocket, ConnectResponse callback) {
            TcpBoundSocketConnectParams _message = new TcpBoundSocketConnectParams();
            _message.remoteAddress = remoteAddress;
            _message.sendStream = sendStream;
            _message.receiveStream = receiveStream;
            _message.clientSocket = clientSocket;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    CONNECT_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new TcpBoundSocketConnectResponseParamsForwardToCallback(callback));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<TcpBoundSocket> {

        Stub(org.chromium.mojo.system.Core core, TcpBoundSocket impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                TcpBoundSocket_Internal.MANAGER, messageWithHeader);
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), TcpBoundSocket_Internal.MANAGER, messageWithHeader, receiver);
                    case START_LISTENING_ORDINAL: {
                        TcpBoundSocketStartListeningParams data =
                                TcpBoundSocketStartListeningParams.deserialize(messageWithHeader.getPayload());
                        getImpl().startListening(data.server, new TcpBoundSocketStartListeningResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    case CONNECT_ORDINAL: {
                        TcpBoundSocketConnectParams data =
                                TcpBoundSocketConnectParams.deserialize(messageWithHeader.getPayload());
                        getImpl().connect(data.remoteAddress, data.sendStream, data.receiveStream, data.clientSocket, new TcpBoundSocketConnectResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class TcpBoundSocketStartListeningParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public org.chromium.mojo.bindings.InterfaceRequest<TcpServerSocket> server;
    
        private TcpBoundSocketStartListeningParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public TcpBoundSocketStartListeningParams() {
            this(0);
        }
    
        public static TcpBoundSocketStartListeningParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static TcpBoundSocketStartListeningParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            TcpBoundSocketStartListeningParams result = new TcpBoundSocketStartListeningParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.server = decoder0.readInterfaceRequest(8, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(server, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            TcpBoundSocketStartListeningParams other = (TcpBoundSocketStartListeningParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.server, other.server))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(server);
            return result;
        }
    }

    static final class TcpBoundSocketStartListeningResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public NetworkError result;
    
        private TcpBoundSocketStartListeningResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public TcpBoundSocketStartListeningResponseParams() {
            this(0);
        }
    
        public static TcpBoundSocketStartListeningResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static TcpBoundSocketStartListeningResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            TcpBoundSocketStartListeningResponseParams result = new TcpBoundSocketStartListeningResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(result, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            TcpBoundSocketStartListeningResponseParams other = (TcpBoundSocketStartListeningResponseParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.result, other.result))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(result);
            return result;
        }
    }

    static class TcpBoundSocketStartListeningResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final TcpBoundSocket.StartListeningResponse mCallback;

        TcpBoundSocketStartListeningResponseParamsForwardToCallback(TcpBoundSocket.StartListeningResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(START_LISTENING_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                TcpBoundSocketStartListeningResponseParams response = TcpBoundSocketStartListeningResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.result);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class TcpBoundSocketStartListeningResponseParamsProxyToResponder implements TcpBoundSocket.StartListeningResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        TcpBoundSocketStartListeningResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result) {
            TcpBoundSocketStartListeningResponseParams _response = new TcpBoundSocketStartListeningResponseParams();
            _response.result = result;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    START_LISTENING_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

    static final class TcpBoundSocketConnectParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 32;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(32, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public NetAddress remoteAddress;
        public org.chromium.mojo.system.DataPipe.ConsumerHandle sendStream;
        public org.chromium.mojo.system.DataPipe.ProducerHandle receiveStream;
        public org.chromium.mojo.bindings.InterfaceRequest<TcpConnectedSocket> clientSocket;
    
        private TcpBoundSocketConnectParams(int version) {
            super(STRUCT_SIZE, version);
            sendStream = org.chromium.mojo.system.InvalidHandle.INSTANCE;
            receiveStream = org.chromium.mojo.system.InvalidHandle.INSTANCE;
        }
    
        public TcpBoundSocketConnectParams() {
            this(0);
        }
    
        public static TcpBoundSocketConnectParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static TcpBoundSocketConnectParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            TcpBoundSocketConnectParams result = new TcpBoundSocketConnectParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.remoteAddress = NetAddress.decode(decoder1);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.sendStream = decoder0.readConsumerHandle(16, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.receiveStream = decoder0.readProducerHandle(20, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.clientSocket = decoder0.readInterfaceRequest(24, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(remoteAddress, 8, false);
            encoder0.encode(sendStream, 16, false);
            encoder0.encode(receiveStream, 20, false);
            encoder0.encode(clientSocket, 24, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            TcpBoundSocketConnectParams other = (TcpBoundSocketConnectParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.remoteAddress, other.remoteAddress))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.sendStream, other.sendStream))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.receiveStream, other.receiveStream))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.clientSocket, other.clientSocket))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(remoteAddress);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(sendStream);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(receiveStream);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(clientSocket);
            return result;
        }
    }

    static final class TcpBoundSocketConnectResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public NetworkError result;
    
        private TcpBoundSocketConnectResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public TcpBoundSocketConnectResponseParams() {
            this(0);
        }
    
        public static TcpBoundSocketConnectResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static TcpBoundSocketConnectResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            TcpBoundSocketConnectResponseParams result = new TcpBoundSocketConnectResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
                result.result = NetworkError.decode(decoder1);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(result, 8, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            TcpBoundSocketConnectResponseParams other = (TcpBoundSocketConnectResponseParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.result, other.result))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(result);
            return result;
        }
    }

    static class TcpBoundSocketConnectResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final TcpBoundSocket.ConnectResponse mCallback;

        TcpBoundSocketConnectResponseParamsForwardToCallback(TcpBoundSocket.ConnectResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CONNECT_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                TcpBoundSocketConnectResponseParams response = TcpBoundSocketConnectResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.result);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class TcpBoundSocketConnectResponseParamsProxyToResponder implements TcpBoundSocket.ConnectResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        TcpBoundSocketConnectResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(NetworkError result) {
            TcpBoundSocketConnectResponseParams _response = new TcpBoundSocketConnectResponseParams();
            _response.result = result;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    CONNECT_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

}

